#pragma once

#include "BaseShader.h"

using namespace std;
using namespace DirectX;

//Shader used to apply motion blur to a texture in the specified direction
class MotionBlurShader : public BaseShader
{
	public:
		MotionBlurShader(ID3D11Device* device, HWND hwnd);
		~MotionBlurShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, ID3D11ShaderResourceView* renderTexture, XMFLOAT2 direction);

	private:
		struct BlurBufferType
		{
			XMFLOAT2 direction;	//Direction in which to apply the blur
			XMFLOAT2 screenDimensions;	//The dimensions of the screen need to be known to calculate texel size
		};

		void initShader(const wchar_t* vs, const wchar_t* ps);

	private:
		ID3D11Buffer* matrixBuffer;
		ID3D11Buffer* blurBuffer;
		ID3D11SamplerState* sampleState;
};

